<!DOCTYPE html>
<html>
<head>
    <script src="https://d3js.org/d3.v7.min.js"></script>
</head>
<body>
    <script>
        // Data containing gender values
        const data = <?php echo json_encode($genderData); ?>;

        // Create a data map for counting occurrences of each gender
        const dataMap = d3.rollup(data, v => v.length, d => d);

        // Convert data map to an array of objects
        const dataArray = Array.from(dataMap, ([gender, count]) => ({ gender, count }));

        // Create SVG container
        const svg = d3.select("body").append("svg").attr("width", 400).attr("height", 300);

        // Create scales
        const xScale = d3.scaleBand().domain(dataArray.map(d => d.gender)).range([50, 350]).padding(0.1);
        const yScale = d3.scaleLinear().domain([0, d3.max(dataArray, d => d.count)]).nice().range([250, 50]);

        // Create bars
        svg.selectAll("rect")
            .data(dataArray)
            .enter().append("rect")
            .attr("x", d => xScale(d.gender))
            .attr("y", d => yScale(d.count))
            .attr("width", xScale.bandwidth())
            .attr("height", d => 250 - yScale(d.count))
            .attr("fill", "steelblue");

        // Create x-axis
        svg.append("g")
            .attr("transform", `translate(0, ${250})`)
            .call(d3.axisBottom(xScale));

        // Create y-axis
        svg.append("g")
            .attr("transform", `translate(50, 0)`)
            .call(d3.axisLeft(yScale));
    </script>
</body>
</html>
